/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.scm.placement;

import com.technicalitiesmc.lib.circuit.component.ComponentType;
import com.technicalitiesmc.lib.circuit.placement.PlacementContext;
import com.technicalitiesmc.lib.math.VecDirection;
import com.technicalitiesmc.scm.component.digital.LeverComponent;
import com.technicalitiesmc.scm.init.SCMComponents;
import com.technicalitiesmc.scm.placement.SinglePlacement;
import javax.annotation.Nullable;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;

public class LeverPlacement
extends SinglePlacement<State> {
    public LeverPlacement() {
        super(false);
    }

    private ComponentType lever() {
        return (ComponentType)SCMComponents.LEVER.get();
    }

    @Override
    @Nullable
    protected State tryCaptureState(PlacementContext.Client context, Vec3i pos, VecDirection clickedFace) {
        if (context.isTopSolid(pos.m_7495_()) && context.canPlace(pos, this.lever())) {
            return new State(pos, context.getHorizontalFacing().getHorizontalIndex());
        }
        return null;
    }

    @Override
    protected void serializeState(FriendlyByteBuf buf, State state) {
        state.serialize(buf);
    }

    @Override
    protected State deserializeState(FriendlyByteBuf buf) {
        return State.deserialize(buf);
    }

    @Override
    protected void put(PlacementContext.Server context, State state) {
        if (context.tryPut(state.pos(), this.lever(), ctx -> {
            LeverComponent lever = new LeverComponent(ctx);
            lever.setRotation(state.rotation());
            return lever;
        })) {
            context.consumeItems(1);
            context.playSound();
        }
    }

    public record State(Vec3i pos, int rotation) {
        public void serialize(FriendlyByteBuf buf) {
            buf.writeInt(this.pos().m_123341_()).writeInt(this.pos().m_123342_()).writeInt(this.pos().m_123343_());
            buf.writeInt(this.rotation());
        }

        public static State deserialize(FriendlyByteBuf buf) {
            Vec3i pos = new Vec3i(buf.readInt(), buf.readInt(), buf.readInt());
            int rotation = buf.readInt();
            return new State(pos, rotation);
        }
    }
}

